#ifndef WAIT_QUEUE_H
#define WAIT_QUEUE_H

// A queue of messages that can be used for producer/consumer problem.
// Provides mutual exclusive access to Add and Remove. When the consumer
// does a Remove and there is no element to remove, it blocks until
// an Add is done.

#include <MessageQueue.h>
#include <OS.h>

class WaitQueue : public BMessageQueue {
	public:
		WaitQueue();
		~WaitQueue();
		
		void Add(BMessage *msg); // caller gives up ownership of message
		BMessage *Remove(); // caller now owns message
		
	private:
		sem_id numItems; // for waiting for an element when there are no more
};

#endif